#include "config.h"

#define PORTIN P3IN
#define PORTOUT P3OUT

#define LE	(BV(0))
#define Q	(BV(1))
#define CLK	(BV(2))
#define DATA	(BV(3))

void ds1123_init(void)
{
	PORTOUT&=~(LE|CLK|DATA);
}

int ds1123_set(int v)
{
	int i;
	int ov=0;

	PORTOUT|=LE;
	for(i=0;i<7;i++)
	{
		if (PORTIN & Q)
			ov=ov<<1|1;
		else
			ov=ov<<1;

		if (v&(0x80>>i))
			PORTOUT|=DATA;
		else
			PORTOUT&=~DATA;

		PORTOUT|=CLK;
		PORTOUT&=~CLK;
	}

	PORTOUT&=~LE;
	return 0;
}
