#include <string.h>
#include <stdio.h>
#include <ctype.h>

#include "config.h"

#define DEFINE
#include "cli.h"
#undef DEFINE
#include "usart.h"
#include "lamps.h"
#include "psmonitor.h"
#include "configuration.h"
#include "max6682.h"

/* $Id: cli.c,v 1.30 2012/04/09 02:03:37 protius Exp $
**
** Tommy's Qswitch Trigger, to observe the pump light of a pulsed laser,
** and trigger an active qswitch.
** Copyright (C) 2010 Tommy Johnson
** 
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
** 
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
** 
*/

static char bpos,cmdbuff[32];

#define WRITESTR(x) usart1Puts(x)
#define WRITECH(x) usart1Putch(x)
#define CHECKEMPTY usart1TxEmpty

void writeStrLong(const char *str)
{
	while(*str)
	{
		if (usart1Putch(*str)>=0)
			str++;
		else
			delay(1000);
	}
}

/* convert a hex digit into its value */
static int hextoval(char c)
{
	if ((c>='0') && (c<='9'))
		return c-'0';
	return (c & 0x07) + 9;
}

void cli_dumphex(int i)
{
        const char *hexdigit="0123456789ABCDEF";
        char buff[6];
        int p;

        for(p=0;p<4;p++)
                buff[p]=hexdigit[(i >> (3-p)*4) & 0x0F];
        buff[4]=0;

        WRITESTR(buff);
}

void cli_init(void)
{
	bpos=0;
	eventclock=0;
}

__attribute__((section(".sourcesection"))) unsigned char source[];

static void dumpsource(void)
{
	int i=0;
	
	snprintf(msgbuff,sizeof(msgbuff),"pos %p \r\n", source);
        WRITESTR(msgbuff);

	for(i=0;i<12000;i++)
	{
		while(usart1Putch(source[i])<0)
			;
	}
	writeStrLong("\r\n\r\n");
}

void cli_event(void)
{
	eventclock+=100;
	writeStrLong("Tick!\r\n");
	lamps_testfire(3000*8);
}

/* Reads an int in hex, returns it, and if e is non-null
** returns the addr of the end of the int in it
*/
static int readinthex(char *p, char **e)
{
	int v=0;
	while((*p) && (isspace(*p)))
		p++;
	while((*p) && (isxdigit(*p)) )
	{
		v=(v<<4) | hextoval(*p);
		p++;
	}
	if (e)
		*e=p;
	return v;
}

/* Reads an int in decimal, returns it, and if e is non-null
** returns the addr of the end of the int in it
*/
static int readintdec(char *p, char **e)
{
	int v=0;
	while((*p) && (isspace(*p)))
		p++;
	while((*p) && (isdigit(*p)))
	{
		v=(v*10) + hextoval(*p);
		p++;
	}
	if (e)
		*e=p;
	return v;
}

static void gotcommand(char *buff)
{
	if (strncasecmp(buff,"off",3)==0)
	{
		int p=4;
		int v=0;
		int i=0;
		/* skip WS here */
		while(!isspace(buff[p]))    // (buff[p]!='\r') && (buff[p]!='\n'))
			i=(i<<4) | hextoval(buff[p++]);
		while((buff[p]) && (isspace(buff[p])))
			p++;
		while((buff[p]!='\r') && (buff[p]!='\n'))
			v=(v<<4) | hextoval(buff[p++]);
		lamps_offsetset(v,i);
		snprintf(msgbuff,sizeof(msgbuff),"offset %d 0x%x\n",i,v);
		WRITESTR(msgbuff);
	}
	if (strncasecmp(buff,"fine",4)==0)
	{
		int p=5;
		int v=0;
		/* skip WS here */
		while((buff[p]!='\r') && (buff[p]!='\n'))
			v=(v<<4) | hextoval(buff[p++]);
		lamps_fineoffsetset(v);
		snprintf(msgbuff,sizeof(msgbuff),"decision= 0x%x\n",v);
		WRITESTR(msgbuff);
	}
	if (strncasecmp(buff,"dec",3)==0)
	{
		int p=4;
		int v=0;
		/* skip WS here */
		while((buff[p]!='\r') && (buff[p]!='\n'))
			v=(v<<4) | hextoval(buff[p++]);
		lamps_decisionset(v);
		snprintf(msgbuff,sizeof(msgbuff),"decision= 0x%x\n",v);
		WRITESTR(msgbuff);
	}
	if (strncasecmp(buff,"jit",3)==0)
	{
		int p=4;
		int v=0;
		/* skip WS here */
		while((buff[p]!='\r') && (buff[p]!='\n'))
			v=(v<<4) | hextoval(buff[p++]);
		lamps_risejitterset(v);
		snprintf(msgbuff,sizeof(msgbuff),"risejitter= 0x%x\n",v);
		WRITESTR(msgbuff);
	}
	if (strncasecmp(buff,"f",1)==0)
	{
		lamps_testfire(3000*8);
	}

	if (strncasecmp(buff,"en",2)==0)
	{
		psmonitor_enable();
	}
	if (strncasecmp(buff,"dis",3)==0)
	{
		psmonitor_disable();
	}
	if (strncasecmp(buff,"pon",3)==0)
	{
		psmonitor_ACOn();
	}
	if (strncasecmp(buff,"poff",4)==0)
	{
		psmonitor_ACOff();
	}
	if (strncasecmp(buff,"volt ",5)==0)
	{
		int v=0;
		v=readintdec(buff+5,NULL);
		curconfig.voltage=v;
		v=psmonitor_voltage_set(curconfig.voltage);
		if (v!=0)
		{
			snprintf(msgbuff,sizeof(msgbuff),"error setting voltage rc=0x%x\n",v);
			WRITESTR(msgbuff);
		}
			
	}
	if (strncasecmp(buff,"curr ",5)==0)
	{
		int v=0;
		v=readintdec(buff+5,NULL);
		curconfig.current=v;
		v=psmonitor_current_set(curconfig.current);
		if (v!=0)
		{
			snprintf(msgbuff,sizeof(msgbuff),"error setting current rc=0x%x\n",v);
			WRITESTR(msgbuff);
		}
	}
	if (strncasecmp(buff,"test ",5)==0)
	{
		int v=0;
		v=readintdec(buff+5,NULL);
		if (v)
			eventclock=slowclock+100;
		else
			eventclock=0;

		snprintf(msgbuff,sizeof(msgbuff),"slowclock 0x%x\n",slowclock);
		WRITESTR(msgbuff);
	}
	if (strncasecmp(buff,"hv ",3)==0)
	{
		int v=0;
		v=readintdec(buff+3,NULL);
		lamps_forcehigh(v);

		if (v)
			WRITESTR("Voltage accross Qswitch!!!!\r\n");
	}


	if (strncasecmp(buff,"th",2)==0)
	{
		max6682Show();
	}
	if (strncasecmp(buff,"temp",4)==0)
	{
		int p=5;
		int v=0;
		int i=0;
		/* skip WS here */
		while(!isspace(buff[p]))    // (buff[p]!='\r') && (buff[p]!='\n'))
			i=(i<<4) | hextoval(buff[p++]);
		while((buff[p]) && (isspace(buff[p])))
			p++;
		v=readintdec(buff+p,NULL);
		max6682Set(i,v);
		snprintf(msgbuff,sizeof(msgbuff),"temp %d %d (DAC %d)\n",i,v,curconfig.tempsetpoint[i]);
		WRITESTR(msgbuff);
	}
	if (strncasecmp(buff,"show",4)==0)
	{
		lamps_show();
		max6682Show();
	}
	if (strncasecmp(buff,"save",4)==0)
	{
		configuration_saveconfig(&curconfig,0);
	}
	if (strncasecmp(buff,"r",1)==0)
	{
		lamps_reset();
	}
	if (strncasecmp(buff,"ps",2)==0)
	{
		psmonitor_show();
	}
	if (strncasecmp(buff,"src",3)==0)
	{
		dumpsource();
	}
	if (strncasecmp(buff,"tst2",4)==0)
	{
		snprintf(msgbuff,sizeof(msgbuff),"clocks %u %u\n",slowclock,max6682clock);
		WRITESTR(msgbuff);
	}
	if ((buff[0]=='?') || (strncasecmp(buff,"help",4)==0))           /* help! */
	{
		writeStrLong("\nTommy's Qswitch Trigger, a product of Tommy's Basement\r\n"
			"$Id: cli.c,v 1.30 2012/04/09 02:03:37 protius Exp $\r\n"
			"Copyright (C) 2010 Tommy Johnson\r\n"
			"This program comes with ABSOLUTELY NO WARRANTY.\r\n"
			"This is free software, and you are welcome to redistribute it\r\n"
			"under certain conditions.\r\n"
			"\r\n"
			"Commands:\r\n"
			"off hexnumber - set Qswitch offset (in clocks)\r\n"
			"fine hexnumber - set Qswitch fine offset (in ns)\r\n"
			"dec hexnumber - decision offset (in clocks)\r\n"
			"jit hexnumber - acceptable jitter in lamps (in clocks)\r\n"
			"volt decnumber - set power supply voltage (volts)\r\n"
			"curr decnumber - set power supply current (microamps)\r\n"
			"hv [int] - force HV to be applied to q-switch\r\n"
			"en - enable HV power supply\r\n"
			"dis - disable HV power supply\r\n"
			"pon - enable 24V power supply\r\n"
			"poff - disable 24V power supply\r\n"
			"th - show thermal status\r\n"
			"temp num temp - set temp set (in Kelvin*10)\r\n"
			"f - fire the qswitch\r\n"
			"test n - if n>0, fire the qswitch at 1 Hz\r\n"
			"r - reset qswitch state machine\r\n"
			"ps - show power supply status\r\n"
			"show - show all config params\r\n"
			"save - write config params to flash\r\n"
			"src - dump the sourcecode (gzipped tarfile)\r\n"
		);
	}
}

void cli_nextchar(unsigned int ch)
{
	/* otherwise: gather the command...  */

	switch(ch)
	{
		default:
			cmdbuff[bpos++]=ch;
			WRITECH(ch);
		break;
		case 127:  /* delete */
		case 8:    /* backspace  */
			if (bpos>0)
				bpos--;
			WRITECH(8);
			WRITECH(32);
			WRITECH(8);
		break;
		case 3:    /* control-C  */
			bpos=0;
			writeStrLong("\r\n\r\n");
		break;
		case 12:   /* control-L  */
			writeStrLong("\r\n\r\n>");
			cmdbuff[bpos]=0;
			writeStrLong(cmdbuff);
		break;
	}

	if ((ch=='\n') || (ch=='\r'))
	{
		cmdbuff[bpos]=0;
		gotcommand(cmdbuff);

		writeStrLong("\r\n>");
		bpos=0;
	}
}
