#include <msp430x44x.h>
#include <signal.h>
#include <io.h>
#include <string.h>
#include <stdio.h>

/* $Id: psmonitor.c,v 1.4 2010/12/12 14:52:34 protius Exp $
**
** Tommy's Qswitch Trigger, to observe the pump light of a pulsed laser,
** and trigger an active qswitch.
** Copyright (C) 2010 Tommy Johnson
** 
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or (at
** your option) any later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*/

#include "cli.h"
#include "config.h"
#define DEFINE
#include "psmonitor.h"
#undef DEFINE

void psmonitor_init(void)
{
        ADC12CTL1=
                CONSEQ_1 |        /* sequence of channels, converted once  */
//                ADC12SSEL_3 |     /* src clock is SMCLOCK  */
                ADC12SSEL_0 |     /* src clock is internal */
                ADC12DIV_2  |     /* Divided by 2  */
                CSTARTADD_0 |     /* First register  */
                SHS_0 |           /* sample clock is by setting ADC12SC  */
                SHP |              /* conversion starts on sample clock */
		0
                ;
                
                ;
        ADC12CTL0=
                ADC12ON |
                REFON |			/* REF2_5V is clear, so 1.5v  */
                SHT0_8 | SHT1_8 |	/* sample time is 8*4 ADC12CLK ticks */
		MSC |			/* multiple sample conversion  */
		0
                ;

        ADC12MCTL0=
                INCH_7 |     /* input channel a7  */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL1=
                INCH_6 |     /* input channel   */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL2=
                INCH_5 |     /* input channel   */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL3=
                INCH_4 |     /* input channel   */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL4=
                INCH_3 |     /* input channel   */
                SREF_1       /* ref+ is vref  ref- is Vss  */
                ;
        ADC12MCTL5=
                INCH_11 |     /* input channel  VCC/2  */
                SREF_0       /*  */
                ;

        ADC12MCTL6=
                INCH_10 |     /* input channel temperature */
                SREF_1 |     /* ref+ is vref  ref- is Vss  */
                EOS             /* end of sequence */
                ;

//        ADC12IE=1<<5;   /* interupt enable on memory 5  */

        ADC12CTL0|=ENC;   /* last thing is set enable  */
}

void psmonitor_show(void)
{
	unsigned int v,i;
	char buff[32];

	ADC12CTL0|=ADC12SC;
	i=0;
	while ((ADC12CTL1 & ADC12BUSY) && (i<0x7FFF))
	{
		i++;
		delay(100);
	}

	if (i>=0x7FFF)
	{
		writeStrLong("i overflowed\r\n");
	}

/*
	Vref is 1.5 or 2.5 V.  
        PS voltage monitor is volts divided by 10,000.  so 1 mV is 10 V out.
	vref / 2^12 is .0003662109, so 1 bit is 3.6621090000 output volts.  

	PS current monitor is 100 mv/ ma.  (and capable of 6ma output)
	so 1 bit is .0036621090 ma of output.

	temp is 3.55 mv per degree K, and 986 mv at 273 degrees K
*/

	for(i=0;i<7;i++)
	{
		v=*(&ADC12MEM0+i);
		snprintf(buff,sizeof(buff),"input %d val 0x%x %d mV\r\n",i,v,(int)(v*0.3662109));
		writeStrLong(buff);
	}
	i=273 +   (((ADC12MEM6 * 0.3662109 )- 986.0)/ 3.55);
	snprintf(buff,sizeof(buff),"temp: %d K\r\n",i);
	writeStrLong(buff);
}

interrupt (ADC_VECTOR) adcIsr(void)
{
}
