#include <signal.h>
#include <io.h>

#define DEFINE
#include "config.h"
#undef DEFINE
#include "usart.h"

#include <string.h>
#include "cli.h"
#include "lamps.h"
#include "psmonitor.h"

/**
Delay function.
*/
void delay(unsigned int d)
{
	int i;
	for (i = 0; i<d; i++)
	{
		nop();
		nop();
	}
}

void cpuInit(void)
{
//	register int del;
	dint();

	// setup ports while waiting for (LF)XT1 to come up
	// setup port 1 from values in config.h
	// P1 is used for boot debugging...  so set it up very-very-first
	P1SEL = P1SEL_INIT;
	P1OUT = P1OUT_INIT;
	P1DIR = P1DIR_INIT;

	P1OUT=1;

	WDTCTL = WDTPW + WDTHOLD;             // stop Watchdog

	FLL_CTL0=DCOPLUS | XCAP0PF;   /* LFXT1 is low frequency xtal, DCO is not divided   possible xcap values are 0, 10, 14, 18 */

	delay(10000);   // sleep to let the crystal stablize

	_BIS_SR(SCG0);
	SCFQCTL=CLOCKMULT-1;   /* want SMCLCK to be ACLK * 100 * 2 This must match a constant in config.h */
			/* Must also match the flash timing controler init in message_buffer.c  */
	SCFI0=FN_3 | FLLD_2;
	SCFI1=SCFQ_512K;

	FLL_CTL1=0;   /* set SELS to 0, so SMCLK = DCOCLK, MCLK=DCOCLK, XT2 off, SMCLCK on   */

	_BIC_SR(SCG0);

	P1OUT=2;
		/* wait for OSC faults to clear */
	while((FLL_CTL0 & 0x07) != 0)
		;
	P1OUT=3;

	// setup port 2 from values in config.h
	P2SEL = P2SEL_INIT;
	P2OUT = P2OUT_INIT;
	P2DIR = P2DIR_INIT;

	// setup port 3 from values in config.h
	P3SEL = P3SEL_INIT;
	P3OUT = P3OUT_INIT;
	P3DIR = P3DIR_INIT;

	// setup port 4 from values in config.h
	P4SEL = P4SEL_INIT;
	P4OUT = P4OUT_INIT;
	P4DIR = P4DIR_INIT;

	// setup port 5 from values in config.h
	P5SEL = P5SEL_INIT;
	P5OUT = P5OUT_INIT;
	P5DIR = P5DIR_INIT;

	// setup port 6 from values in config.h
	P6SEL = P6SEL_INIT;
	P6OUT = P6OUT_INIT;
	P6DIR = P6DIR_INIT;

#if 0

  // wait for (LF)XT1 oscillator to come up
  // clear OSC fault flag & set delay count
  // exit loop when no fault for delay count
  for (IFG1 &= ~OFIFG, del = 255; del; )
    {
    if (IFG1 & OFIFG)                   // check OSC fault flag
      {
      // it's set
      IFG1 &= ~OFIFG;                   // clear OSC fault flag
      del = 255;                      // reset delay count
      }
    else
      --del;                          // clear, decrement delay
    }
#endif

	eint();
	P1OUT=4;
}

/* endless loop, blink 
*/
int blink(void)
{
	int i;
	while(1)
	{
		P5OUT=~(P5OUT);
		for(i=0;i<0xffff;i++)
		{
			nop();
			nop();
			nop();
			nop();
		}
	}
}

int main(void)
{
	int ch;
	int i;

	P5SEL = P5SEL_INIT;
	P5OUT = P5OUT_INIT;
	P5DIR = P5DIR_INIT;

	P3SEL = P3SEL_INIT;
	P3OUT = P3OUT_INIT;
	P3DIR = P3DIR_INIT;

	cpuInit();
	P1OUT=6;

	delay(0x7FF0);    /* This is here so we don't actualy unsafe the display until /after/ the jtag would have reset us.  We don't want the display to be actuve unless we're in complete control */


	usart1Init(USART1_BAUD_DIV(9600), USART1_BAUD_MOD(9600), USART_8N1);
//	usart0Init(USART0_BAUD_DIV(9600), USART0_BAUD_MOD(9600), USART_8N1);

	cli_init();
	lamps_init();
	psmonitor_init();

#if 1
	TESTPUTS("\n\rHello World\r\n>");
#endif

#if 0
/* USART test:
**  echos everything received back
*/
	for (;;)
	{
		if ((ch = usart0Getch()) >= 0)
		{
			usart0Putch(ch);
		}
	}
#endif
	for (;;)
	{
#if 0
		if ((ch = usart0Getch()) > 0)     /* got a char from the IR receiver?  */
		{
		}
#endif

		if ((ch = usart1Getch()) >= 0)     /* got a char from the rs232?  */
		{	
			cli_nextchar(ch);
		}

		lamps_status();
		WDOG();
	}

  return 0;                             // should NEVER get here
}
